﻿### WBS取込 from Excel to OBPM via API

### 初期設定

# 取込ファイル
$importFile = "$PSScriptRoot\WBS一覧.xlsx"

# OBPM API
$hostname = "tr-e-it-api.obpm-neo-demo.com"                 # APIのURLホスト名
$tenant_id = "d6abb579-fba2-4700-9ab7-f89f5dd996e4"         # アプリのテナントID
$client_id = "4a573796-87d9-4014-ac36-f90023215a22"         # アプリのクライアントID
$client_secret = "FNq8Q~GGP06f74sLo5yReGM6XN3gvCgXksemOcq9" # クライアントシークレット

### OBPMアクセストークン取得

$tokenBody = @{
    grant_type = "client_credentials"
    client_id = $client_id
    client_secret = $client_secret
    scope = "api://$client_id/.default"
}
$tokenUrl = "https://login.microsoftonline.com/$tenant_id/oauth2/v2.0/token"
$tokenResult = $null
try {
    $tokenResult = Invoke-RestMethod -Uri $tokenUrl -Method Post -Body $tokenBody
    $accessToken = $tokenResult.access_token
} catch {
    Write-Error "アクセストークンの取得に失敗しました: $($_.Exception.Message)"
    exit 1
}

$headers = @{
    "Cache-Control" = "no-cache"
    "Authorization" = "Bearer $accessToken"
    "Content-Type" = "application/json"
}

### Excel読込

$excel = New-Object -ComObject Excel.Application
$excel.Visible = $false
$workbook = $excel.Workbooks.Open($importFile)
$sheet = $workbook.Sheets.Item(1)

# プロジェクトコード取得
$pjCodes = $sheet.Name
$wbsUrl = "https://$hostname/api/v1/projects/$pjCodes/wbs"

# 最初の空行を取得（A列）
$row = 2
while ($sheet.Cells.Item($row, 1).Text -ne "") { $row++ }
$firstFreeRow = $row
if ($firstFreeRow -le 2) {
    $workbook.Close($true)
    $excel.Quit()
    exit
}

### WBS削除処理

$getUrl = "$wbsUrl"
$getResult = $null
try {
    $getResult = Invoke-RestMethod -Uri $getUrl -Method Get -Headers $headers
    $wbsItems = $getResult.data | Where-Object { $_.wbsType -ne "detail" } | Sort-Object layer -Descending
} catch {
    Write-Error "WBSの取得に失敗しました: $($_.Exception.Message)"
    exit 1
}

# ExcelのColumn14を取得（WBSコード列）
$excelWbsCodes = @()
for ($i = 2; $i -lt $firstFreeRow; $i++) {
    $excelWbsCodes += $sheet.Cells.Item($i, 14).Text
}

foreach ($wbs in $wbsItems) {
    $wbsCode = $wbs.wbsCode
    if (-not ($excelWbsCodes -contains $wbsCode)) {
        $delUrl = "$wbsUrl/$wbsCode"
        $delResult = $null
        try {
            $delResult = Invoke-RestMethod -Uri $delUrl -Method Delete -Headers $headers
        } catch {
            Write-Warning "WBSの削除に失敗しました（WBSコード: $wbsCode）: $($_.Exception.Message)"
            continue
        }
    }
}

### WBS登録・更新処理

for ($level = 1; $level -le 4; $level++) {
    for ($i = 2; $i -lt $firstFreeRow; $i++) {
        $wbsName = $sheet.Cells.Item($i, $level + 1).Text
        if ([string]::IsNullOrWhiteSpace($wbsName)) { continue }

        $parentWbsCode = if ($level -eq 1) { 0 } else { [int]$sheet.Cells.Item($i, 13 + $level).Text }
        $planStartDate = $sheet.Cells.Item($i, 6).Text
        $planEndDate = $sheet.Cells.Item($i, 7).Text
        $actualStartDate = $sheet.Cells.Item($i, 11).Text
        $actualEndDate = $sheet.Cells.Item($i, 12).Text
        $progressRate = if ($sheet.Cells.Item($i, 13).Text) { [int]$sheet.Cells.Item($i, 13).Text } else { 0 }
        $planValue = if ($sheet.Cells.Item($i, 8).Text) { [int]$sheet.Cells.Item($i, 8).Text } else { 0 }
        $accountCode = $sheet.Cells.Item($i, 9).Text
        $isBottom = $sheet.Cells.Item($i, 18).Text
        $wbsCode = $sheet.Cells.Item($i, 14).Text

        $assigners = @()
        if ($accountCode) {
            $assigners += @{ accountCode = $accountCode; isMain = $true }
        }

        if (-not $wbsCode) {
            $wbsItem = @{
                wbsName = $wbsName
                parentWbsCode = $parentWbsCode
                interfaceCode = ""
                progressInfo = @{
                    planStartDate = $planStartDate
                    planEndDate = $planEndDate
                    actualStartDate = $actualStartDate
                    actualEndDate = $actualEndDate
                    progressRate = $progressRate
                    remarks = ""
                    manValueInfo = @{ planValue = $planValue; unit = "day" }
                    assigners = $assigners
                }
            }
            $json = ($wbsItem | ConvertTo-Json -Depth 5).Replace('""', 'null')
            $postUrl = "$wbsUrl"
            $postResult = $null
            $postResult = Invoke-WebRequest -Uri $postUrl -Method Post -Headers $headers -Body $json -ContentType "application/json; charset=utf-8"
            $result = ConvertFrom-Json $postResult.Content
            if ($postResult.StatusCode -eq 200) {
                $sheet.Cells.Item($i, 14).Value2 = $result.wbsCode
                $sheet.Cells.Item($i, 19).Value2 = "登録完了"
            } else {
                $sheet.Cells.Item($i, 19).Value2 = $result.message
            }
        } else {
            if ($isBottom -eq 1) {
                $wbsItem = @{
                    wbsName = $wbsName
                    interfaceCode = ""
                    progressInfo = @{
                        planStartDate = $planStartDate
                        planEndDate = $planEndDate
                        actualStartDate = $actualStartDate
                        actualEndDate = $actualEndDate
                        progressRate = $progressRate
                        remarks = ""
                        manValueInfo = @{ planValue = $planValue; unit = "day" }
                        assigners = $assigners
                    }
                }
            } else {
                $wbsItem = @{
                    wbsName = $wbsName
                    interfaceCode = ""
                    progressInfo = @{
                        planStartDate = $planStartDate
                        planEndDate = $planEndDate
                        remarks = ""
                        assigners = $assigners
                    }
                }
            }
            $json = ($wbsItem | ConvertTo-Json -Depth 5).Replace('""', 'null')
            $putUrl = "$wbsUrl/$wbsCode"
            $putResult = $null
            $putResult = Invoke-WebRequest -Uri $putUrl -Method Put -Headers $headers -Body $json -ContentType "application/json; charset=utf-8"
            $result = ConvertFrom-Json $putResult.Content
            if ($putResult.StatusCode -eq 200) {
                $sheet.Cells.Item($i, 19).Value2 = "更新完了"
            } else {
                $sheet.Cells.Item($i, 19).Value2 = $result.message
            }
        }
    }
}

### Excel保存と終了
$workbook.Save()
$workbook.Close($true)
$excel.Quit()
$excel = $null

Write-Host "処理が完了しました。"
