﻿### OBPMの実績工数をRedmineの作業時間に登録するサンプルスクリプト

### 初期設定

# OBPM API
$hostname = "tr-e-it-api.obpm-neo-demo.com"                 # APIのURLホスト名
$tenant_id = "d6abb579-fba2-4700-9ab7-f89f5dd996e4"         # アプリのテナントID
$client_id = "4a573796-87d9-4014-ac36-f90023215a22"         # アプリのクライアントID
$client_secret = "FNq8Q~GGP06f74sLo5yReGM6XN3gvCgXksemOcq9" # クライアントシークレット

# Redmine API
$redmineApiKey = "Redmine API Key"                          # APIキー

### OBPMアクセストークン取得

$tokenBody = @{
    grant_type = "client_credentials"
    client_id = $client_id
    client_secret = $client_secret
    scope = "api://$client_id/.default"
}
$tokenUrl = "https://login.microsoftonline.com/$tenant_id/oauth2/v2.0/token"
$tokenResult = $null
try {
    $tokenResult = Invoke-RestMethod -Uri $tokenUrl -Method Post -Body $tokenBody
    $accessToken = $tokenResult.access_token
} catch {
    Write-Error "アクセストークンの取得に失敗しました: $($_.Exception.Message)"
    exit 1
}

### OBPM実績工数取得（汎用データ出力API）

$getHeaders = @{
    "Cache-Control" = "no-cache"
    "Authorization" = "Bearer $accessToken"
    "Content-Type" = "application/json"
}

$patternId = "278"
$getUrl = "https://$hostname/api/v1/export/$patternId"
$getResult = $null
try {
    $getResult = Invoke-RestMethod -Uri $getUrl -Method Get -Headers $getHeaders
} catch {
    Write-Error "実績工数の取得に失敗しました: $($_.Exception.Message)"
    exit 1
}

### Redmine作業時間登録（Time Entries API）

foreach ($dr in $getResult.data) {
    # チケットIDはWBSのIFコードを参照
    $issue_id = ""
    if ([string]::IsNullOrEmpty($dr.issue_id_l5) -eq $false) {
        $issue_id = $dr.issue_id_l5
    } elseif ([string]::IsNullOrEmpty($dr.issue_id_l4) -eq $false) {
        $issue_id = $dr.issue_id_l4
    } elseif ([string]::IsNullOrEmpty($dr.issue_id_l3) -eq $false) {
        $issue_id = $dr.issue_id_l3
    } elseif ([string]::IsNullOrEmpty($dr.issue_id_l2) -eq $false) {
        $issue_id = $dr.issue_id_l2
    } elseif ([string]::IsNullOrEmpty($dr.issue_id_l1) -eq $false) {
        $issue_id = $dr.issue_id_l1
    }

    $timeEntry = @{
        time_entry = @{
            project_id = $dr.project_identifier
            issue_id   = $issue_id
            spent_on   = $dr.spent_on.Replace("/", "-")
            hours      = $dr.hours
        }
    }
    $jsonBody = $timeEntry | ConvertTo-Json -Depth 3

    $postHeaders = @{
        "X-Redmine-API-Key" = $redmineApiKey
        "X-Redmine-Switch-User" = $dr.user_login
        "Content-Type" = "application/json"
    }

    $postUrl = "http://$redminehost/redmine/time_entries.json"
    $postResponse = $null
    try {
        $postResponse = Invoke-RestMethod -Uri $postUrl -Method Post -Headers $postHeaders -Body $jsonBody
    } catch {
        Write-Warning "作業時間の登録に失敗しました（ユーザー: $($dr.user_login), チケット: $issue_id）: $($_.Exception.Message)"
        continue
    }
}

Write-Host "処理が完了しました。"
