﻿### TeamSpirit勤怠データを取得し、OBPMにCSVファイルを転送するサンプルスクリプト

### 初期設定

# Salesforce API
$hostname = "teamspirit.my.salesforce.com"  # APIのURLホスト名
$client_id = "Salesforce Client Id"         # アプリのクライアントID
$client_secret = "Salesforce Client Secret" # クライアントシークレット

# 勤怠データファイル
$filePathPrefix = "$PSScriptRoot\kintai"

# Azure Storage
$stAccount = "staccount"
$stShare = "stshare"
$stDirectoryPath = "OBPM/AutoImport/WorkingResultDayIF"
$SAS = "stsas"

### Salesforceアクセストークン取得

$tokenBody = @{
    grant_type = "client_credentials"
    client_id = $client_id
    client_secret = $client_secret
}
$tokenUrl = "https://$hostname/services/oauth2/token"
$tokenResult = $null
try {
    $tokenResult = Invoke-RestMethod -Uri $tokenUrl -Method Post -Body $tokenBody
    $accessToken = $tokenResult.access_token
} catch {
    Write-Error "アクセストークンの取得に失敗しました: $($_.Exception.Message)"
    exit 1
}

### TeamSpirit勤怠データ取得

$getHeaders = @{
    "Cache-Control" = "no-cache"
    "Authorization" = "Bearer $accessToken"
    "Content-Type" = "application/json"
}

$ym = "202510"

$soql = @"
SELECT
+teamspirit__EmpMonthId__r.teamspirit__EmpId__r.teamspirit__EmpCode__c,
+teamspirit__EmpMonthId__r.teamspirit__EmpId__r.Name,
+teamspirit__DayType__c,
+teamspirit__DayTypeView__c,
+teamspirit__Date__c,
+teamspirit__WorkRealTimeH__c,
+teamspirit__StartTimeHHMM__c,
+teamspirit__EndTimeHHMM__c
+FROM+teamspirit__AtkEmpDay__c
+WHERE+teamspirit__EmpMonthId__r.teamspirit__YearMonth__c+=+$ym
"@
$query = $soql -replace "`r`n", ""

$getUrl = "https://$hostname/services/data/v50.0/query/?q=$query"
$getResult = $null
try {
    $getResult = Invoke-RestMethod -Uri $getUrl -Method Get -Headers $getHeaders
} catch {
    Write-Error "勤怠データの取得に失敗しました: $($_.Exception.Message)"
    exit 1
}

### 勤怠データファイル作成

$filePath = $null

if ($getResult.records.Count -gt 0) {
    # 勤怠データファイルを準備する。
    $now = Get-Date -Format yyyyMMddHHmmssfff
    $filePath = "$filePathPrefix.$now.csv"

    # 勤怠データファイルを作成する。
    $dtWork = @()
    foreach ($dr in $getResult.records)
    {
        $drWork = New-Object PSCustomObject
        $drWork | Add-Member -MemberType NoteProperty -Name "担当者コード" -Value $dr.teamspirit__EmpMonthId__r.teamspirit__EmpId__r.teamspirit__EmpCode__c
        $drWork | Add-Member -MemberType NoteProperty -Name "実績日" -Value $dr.teamspirit__Date__c.Replace("-","/")
        $dateType = $null
        $workTime = $null
        if ($dr.teamspirit__WorkRealTimeH__c -ne 0) {
            switch ($dr.teamspirit__DayType__c) {
                "0" { $dateType = "WD" }
                "1" { $dateType = "HD1" }
                "2" { $dateType = "HD2" }
                "3" { $dateType = "HD1" }
            }
            $workTime = $dr.teamspirit__WorkRealTimeH__c
        }
        $drWork | Add-Member -MemberType NoteProperty -Name "勤務パターンI/Fコード" -Value $dateType
        if ($dr.teamspirit__DayType__c -eq "0") {
            $drWork | Add-Member -MemberType NoteProperty -Name "所定時間" -Value $workTime
            $drWork | Add-Member -MemberType NoteProperty -Name "所定外時間" -Value $null
        } else {
            $drWork | Add-Member -MemberType NoteProperty -Name "所定時間" -Value $null
            $drWork | Add-Member -MemberType NoteProperty -Name "所定外時間" -Value $workTime
        }
        $drWork | Add-Member -MemberType NoteProperty -Name "出社" -Value $dr.teamspirit__StartTimeHHMM__c
        $drWork | Add-Member -MemberType NoteProperty -Name "退社" -Value $dr.teamspirit__EndTimeHHMM__c
        $dtWork += ($drWork)
    }
    $dtWork | Export-Csv -Path $filePath -Encoding UTF8 -NoTypeInformation
}

### 勤怠データファイル転送

if ($null -ne $filePath) {
    $fSize = [System.IO.File]::ReadAllBytes($filePath).Count
    $fName = [System.Uri]::EscapeDataString((Get-Item $filePath).Name)
    $crtUri = "https://${stAccount}.file.core.windows.net/${stShare}/${stDirectoryPath}/${fName}?${SAS}"
    $putUri = "https://${stAccount}.file.core.windows.net/${stShare}/${stDirectoryPath}/${fName}?comp=range&${SAS}"
    $range = "0-$([string]($fSize - 1))"
    $crtTime = Get-Date -UFormat "%Y/%m/%d %H:%M:%S"

    # 空ファイル作成
    curl.exe -i -v -X PUT -H "x-ms-date: ${crtTime}" -H "x-ms-version: 2021-06-08" -H "x-ms-content-length: ${fSize}" -H "x-ms-type: file" -H "x-ms-file-permission: Inherit" -H "x-ms-file-attributes: Archive" -H "x-ms-file-creation-time: Now" -H "x-ms-file-last-write-time: Now" -H "Content-Length: 0" --globoff $crtUri

    # ファイルにデータ流し込み
    curl.exe -i -v -X PUT -H "x-ms-write: update" -H "x-ms-date: ${crtTime}" -H "x-ms-version: 2021-06-08" -H "Range: bytes=${range}" -H "Content-Length: ${fSize}" --data-binary @$filePath --globoff $putUri
}

Write-Host "処理が完了しました。"
